
uniform sampler2D u_texture;
uniform mediump vec2 u_blurUVDir;

varying lowp vec4 v_fragmentColor;
varying highp vec2 v_texCoord;

#ifdef CLAMP_UV
uniform mediump vec4 u_uvClamp;
#define clamp_uv(uv) clamp(uv, u_uvClamp.xy, u_uvClamp.zw)
#else
#define clamp_uv(uv) (uv)
#endif

void main()
{
	mediump vec4 color = texture2D(u_texture, clamp_uv(v_texCoord));
	for (int i = 1; i <= NUM_SAMPLES; ++i)
	{
		color += texture2D(u_texture, clamp_uv(v_texCoord + u_blurUVDir * i));
		color += texture2D(u_texture, clamp_uv(v_texCoord - u_blurUVDir * i));
	}
	color /= NUM_SAMPLES * 2 + 1;
	gl_FragColor = v_fragmentColor * color;
}
